



/*********************************************************************************************************************
 *                                                                                                                   *
 *                             Example_2. ET-REMOTE MP3 Trig-Mode By Check EOF Signal                                *
 *                                                                                                                   *
 *********************************************************************************************************************
 *                                                                                                                   *
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722 (ICD2))                                                           *
 *                   : X-TAL : 10 MHz                                                                                *
 *                   : CPU Clock = 40 MHz (x4)                                                                       *                                                                  
 * Editor-Compiler   : CCS Version 4.120                                                                             *
 *                                                                                                                   *
 *                                                                                                                   *
 * Port Interface    :  # MCU-18F8722 #            # ET-MINI 3TO5TTL #                     # ET-REMOTE MP3 #         *
 *                      --------------             -------------------                     -----------------         * 
 *                                                                                                                   *
 *       I/O TRIG    :  PORT RD[0..7]   Connect  IN0-IN7(#1)<--> OUT0-OUT7(#1)   Connect    Trig CH1-CH8             * 
 *                      PORT RE[0..7]   Connect  IN0-IN7(#2)<--> OUT0-OUT7(#2)   Connect    Trig CH9-CH16            *
 *                      PORT RC0         ------------------------------------    Connect    EOF Terminal             *
 *                      +5V             Connect  +VIN(#1,#2)<--> +VOUT(#1,#2)    Connect    +3.3V                    *
 *                      G               Connect  G   (#1,#2)<-->  G   (#1,#2)    Connect     G                       *
 *                                                                                                                   *                                                                                                                *
 *                                                                                                 -DIP SW.MODE      *
 *                         5V                                                                       S1=OFF,S2=OFF    *
 *                        --+--                                            +------------------+    -DIP SW.CONFIG    *
 *                          |                                              |                  |     S1=OFF,S2=ON     *
 *                          +----------+                                   |          --------+-----------           *
 *                          |          |      -----------------------      |         |     +VOUT3V3       |          *
 *                    ------+-----     +-----|+VIN              +VOUT|-----+    Trig |                    |          *
 *                   |        RD0 |----|-----|IN0                OUT0|-----|---------|CH1                 |          *
 *                   |         .  |    |     | .                  .  |     |         | .                  |          *
 *                   |         .  |    |     | .   ET-MINI3TO5#1  .  |     |         | .                  |          *
 *                   |         .  |    |     | .                  .  |     |         | .                  |          *
 *                   |        RD7 |----|-----|IN7                OUT7|-----|---------|CH8                 |          *
 *                   |            |    |  +--|G                    G |--+  |         |                    |          *
 *                   |            |    |  |  +-----------------------+  |  |         |   ET-REMOTE MP3V2  |          *
 *                   |            |    +--|--|+VIN              +VOUT|--|--+    Trig |                    |          *
 *                   |        RE0 |-------|--|IN0                OUT0|--|------------|CH9                 |          *
 *                   |         .  |       |  | .                  .  |  |            | .                  |          *
 *                   |         .  |       |  | .   ET-MINI3TO5#2  .  |  |            | .               EOF|---+      *
 *                   |         .  |       |  | .                  .  |  |            | .                  |   |      *
 *                +--|RC0     RE7 |-------|--|IN7                OUT7|--|------------|CH16   [Supply]     |   |      *
 *                |   -----+------        +--|G                    G |--+            |       G    5V      |   |      *
 *                |        | PIC18F8722   |   -----------------------   |             -------+-----+------    |      *
 *                |      --+--            |                             |                    |     |          |      *
 *                |       ---             +-----------------------------+--------------------+     |          |      *
 *                |        -              |                                                  |     +-->5V     |      *
 *                |                     --+--                                              --+--              |      *
 *                |                      ---                                                ---               |      *
 *                |                       -                                                  -                |      *
 *                |                                                                                           |      *
 *                +-------------------------------------------------------------------------------------------+      *
 *                                                                                                                   *
 *                                                                                                                   *
 *                                                                                                                   *
 * Last Update       : 1/June/2012                                                                                   *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                          *
 *                                                                                                                   *
 *********************************************************************************************************************/


#include <18F8722.h>
#include <stdio.h>

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)
#use fast_io(ALL)  //Stop Set direction Auto for All Port  by Compiler  


/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {   
    set_tris_D(0x00)                ;        //Set RD(0..7) = Output for Trig CH1-8    
    set_tris_E(0x00)                ;        //Set RE(0..7) = Output for Trig CH9-16  
    set_tris_C(0x01)                ;        //Set RC0      = Input for Read EOF 

   
  //--- Set default output Port For Trig = 1  ----
                
   OUTPUT_D(0xFF)                  ;       //CH1-CH8  
   OUTPUT_E(0xFF)                  ;       //CH9-CH16
   
   
 }
   
   
 /*************************************************************************  
  **           Function Check Status Signal EOF : End OF File            **
  *************************************************************************/

void Chk_Eof(void)
{
  int8 eof                 ;
       
  do                            //Loop Check Eof = 0 :end file 
   {
     eof  = INPUT(PIN_C0)     ; //Read RC0 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x01        ; //Mark bit 0
   }while(eof == 1)           ; //eof = 0 exit loop
    
  do                            //Loop Check Eof = 1 : Ready 
   {
     eof  = INPUT(PIN_C0)     ; //Read RC0 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x01        ; //Mark bit 0
   }while(eof == 0)           ; //eof = 1 exit loop
  
}



 /****************************************************
  **                                                **
  **     Function Play File CH1-CH16(Trig'0')       **
  **                                                **
  ****************************************************/ 


void Play_File(void)
{  
  int8 bt,bi=0xFE,del=0x01 ;
  
    //--------------- PORT_RD[0..7] TRIG CH[1..8]-------------

  for(bt=0;bt<8;bt++)           //Loop Control Port bit for Trig Next File
   {                   
     OUTPUT_D(bi)           ;   //Port_RD_Bit(x)=0 : Trig-CH(x+1)   

     delay_ms(20)           ;   //Delay 20 ms for Trig 0

     OUTPUT_D(0xFF)         ;   //Port_RD_Bit(All)= 1  

     Chk_Eof()              ;   //Check Play End File
       
     bi = bi-del        ;    //Mark bit x = 0 (x=0-7)
     del= del << 1      ;    //Value for use Mark bit 
  
   }

    //--------------- PORT_RE[0..7] TRIG CH[9..16]-------------
    
  bi  = 0xFE                 ;    //Initial Start Mark bit0 =0
  del = 0x01                 ;    //Initial value mark bit =1

  for(bt=0;bt<8;bt++)              //Loop Control Port bit for Trig Next File
   {                     
     OUTPUT_E(bi)            ;    //Port_RE_Bit(x)=0 : Trig-CH(x+9)   

     delay_ms(20)            ;    //Delay 20 ms for Trig 0
 
     OUTPUT_E(0xFF)          ;    //Port_RE_Bit(ALL)=1  
 
     Chk_Eof()               ;    //Check Play End File
        
     bi = bi-del         ;    //Mark bit x = 0 (x=0-7)
     del= del << 1       ;    //Value for use Mark bit 
    
   }
}


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 void main(void) 
 {
    Init_Port()       ;
    delay_ms(2000)    ;  //delay 3 sec for Synce Board MP3 Ready
    
   while(true)
   {
    delay_ms(3000)  ;
    Play_File()     ;   //Sen Signal Trig Start Play File CH1
   }   
}

